// like lookup searcher, only uses events

package corejini.chapter9;

import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceEvent;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceID;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.lease.LeaseRenewalManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.io.IOException;

public class ServiceInfoWatcher extends ServiceInfoSearcher {
    protected Listener listener;
    protected LeaseRenewalManager mgr;
    protected HashMap leases = new HashMap();
    protected int transitions = 
	ServiceRegistrar.TRANSITION_MATCH_NOMATCH |
        ServiceRegistrar.TRANSITION_NOMATCH_MATCH |
        ServiceRegistrar.TRANSITION_MATCH_MATCH;
    
    class Listener extends UnicastRemoteObject 
        implements RemoteEventListener {
        
        public Listener() throws RemoteException {
        }
        
        public void notify(RemoteEvent ev) 
            throws RemoteException {
            if (!(ev instanceof ServiceEvent)) {
                System.err.println("Unexpected event: " +
                                   ev.getClass().getName());
                return;
            }
            
            ServiceEvent serviceEvent = (ServiceEvent) ev;
            
            switch (serviceEvent.getTransition()) {
            case ServiceRegistrar.TRANSITION_NOMATCH_MATCH:
                addService(serviceEvent.getServiceItem());
                break;
            case ServiceRegistrar.TRANSITION_MATCH_NOMATCH:
                removeService(serviceEvent.getServiceID());
                break;
            case ServiceRegistrar.TRANSITION_MATCH_MATCH:
                serviceChanged(serviceEvent.getServiceItem());
                break;
            }
        }
    }
    
    public ServiceInfoWatcher() 
	throws IOException, RemoteException {
        mgr = new LeaseRenewalManager();
        listener = new Listener();
    }
    
    protected void removeService(ServiceID serviceID) {
        services.remove(serviceID);
        System.out.println("Service no longer available: "
                           + serviceID);
    }
    
    protected void serviceChanged(ServiceItem item) {
        services.put(item.serviceID, item);
        System.out.println("Service updated: " + 
                           item.serviceID);
        printServiceInfo(item);
    }
    
    // overrride addRegistrar and removeRegistrar to have them
    // ask for/terminate event solicitations whenever we find a 
    // lookup service.
    protected void addRegistrar(ServiceRegistrar reg) {
        try {
            super.addRegistrar(reg);
            
            EventRegistration er = reg.notify(tmpl, 
					      transitions, 
					      listener,
                                              null, 
					      10 * 60 * 1000);
            // do something with lease
            leases.put(reg.getServiceID(), er.getLease());
            mgr.renewUntil(er.getLease(), Lease.ANY, null);
        } catch (RemoteException ex) {
            System.err.println("Can't solicit event: " +
                               ex.getMessage());
        }
    }
    protected void removeRegistrar(ServiceRegistrar reg) {
        try {
            super.removeRegistrar(reg);
            
            // terminate leases on this dude.
            Lease lease = (Lease) 
                leases.get(reg.getServiceID());
        
            if (lease == null)
                return;
        
            leases.remove(reg.getServiceID());
	    // May raise unknown lease exception or
	    // remote exception. Should be ok to ignore
	    // here...
            mgr.cancel(lease);
        } catch (Exception ex) {
        }
    }
    
    public static void main(String[] args) {
        try {
            ServiceInfoWatcher watcher = new ServiceInfoWatcher();
            new Thread(watcher).start();
        } catch (Exception ex) {
            System.err.println("Error starting watcher: " +
                               ex.getMessage());
        }
    }
}
