// Find and print services that have ServiceInfo 
// attributes.

package corejini.chapter9;

import net.jini.discovery.LookupDiscoveryManager;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.core.entry.Entry;
import java.util.HashMap;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.io.IOException;

public class ServiceInfoSearcher implements Runnable {
    protected HashMap registrars = new HashMap();
    protected HashMap services = new HashMap();
    protected ServiceTemplate tmpl;
    
    class Discoverer implements DiscoveryListener {
        public void discovered(DiscoveryEvent ev) {
            ServiceRegistrar[] newregs = ev.getRegistrars();
            for (int i=0 ; i<newregs.length ; i++) {
                addRegistrar(newregs[i]);
            }
        }
        public void discarded(DiscoveryEvent ev) {
            ServiceRegistrar[] newregs = ev.getRegistrars();
            for (int i=0 ; i<newregs.length ; i++) {
                removeRegistrar(newregs[i]);
            }
        }
    }
    
    public ServiceInfoSearcher() throws IOException {
	if (System.getSecurityManager() == null) {
	    System.setSecurityManager(
		    new RMISecurityManager());
	}

        // build our template
        Entry[] attrTemplates = new Entry[1];
        attrTemplates[0] = 
            new ServiceInfo(null, null, null, 
                            null, null, null);
        tmpl = new ServiceTemplate(null, 
                                   null, 
                                   attrTemplates);
        
        // set up for discovery
        LookupDiscoveryManager disco = 
            new LookupDiscoveryManager(LookupDiscoveryManager.ALL_GROUPS,
				       null, new Discoverer());
    }
    
    protected synchronized void addRegistrar(ServiceRegistrar reg) {
        if (registrars.containsKey(reg.getServiceID()))
            return;
            
        registrars.put(reg.getServiceID(), reg);
        findServices(reg);
    }
    protected synchronized void removeRegistrar(ServiceRegistrar reg) {
        if (!registrars.containsKey(reg.getServiceID()))
            return;
        
        registrars.remove(reg.getServiceID());
    }
    
    void findServices(ServiceRegistrar reg) {
        try {
            ServiceMatches matches = 
                reg.lookup(tmpl, Integer.MAX_VALUE);
        
            for (int i=0 ; i<matches.totalMatches ; i++) {
                if (services.containsKey(matches.items[i].serviceID))
                    continue;
            
        
                addService(matches.items[i]);
            }
        } catch (RemoteException ex) {
            System.err.println("Couldn't search: " +
                               ex.getMessage());
        }
    }
    
    protected void addService(ServiceItem item) {
        services.put(item.serviceID, item);
        System.out.println("New service found: " + 
                           item.serviceID);
        printServiceInfo(item);
    }
    
    public static void printServiceInfo(ServiceItem item) {
        for (int i=0 ; i<item.attributeSets.length ; i++) {
            if (item.attributeSets[i] instanceof ServiceInfo) {
                ServiceInfo info = 
                    (ServiceInfo) item.attributeSets[i];
                System.out.println("  Name = " + 
                                   info.name);
                System.out.println("  Manufacturer = " + 
                                   info.manufacturer);
                System.out.println("  Vendor = " + 
                                   info.vendor);
                System.out.println("  Version = " + 
                                   info.version);
                System.out.println("  Model = " + 
                                   info.model);
                System.out.println("  Serial Number = " + 
                                   info.serialNumber);

		System.out.println("  Proxy is " + 
                                   item.service);
            }
        }
    }
    
    public void run() {
        while (true) {
            try {
                Thread.sleep(Long.MAX_VALUE);
            } catch (InterruptedException ex) {
            }
        }
    }
    
    public static void main(String args[]) {
        try {
            ServiceInfoSearcher searcher = 
                new ServiceInfoSearcher();
            new Thread(searcher).start();
        } catch (Exception ex) {
            System.err.println("Error starting searcher: " +
                               ex.getMessage());
            ex.printStackTrace();
        }
    }
}
