// Cause two lookup services to register with each
// other.

package corejini.chapter9;

import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.admin.Administrable;
import net.jini.admin.JoinAdmin;
import java.net.MalformedURLException;
import java.io.IOException;
import java.rmi.RMISecurityManager;

public class Federate {
    public Federate() {
	if (System.getSecurityManager() == null) {
	    System.setSecurityManager(
		    new RMISecurityManager());
	}
    }
    
    public boolean federate(String url1, String url2) 
        throws MalformedURLException, IOException, 
	       ClassNotFoundException {
        // Get service registrars for both servers
        LookupLocator loc1 = new LookupLocator(url1);
        LookupLocator loc2 = new LookupLocator(url2);
        
        ServiceRegistrar reg1 = loc1.getRegistrar();
        ServiceRegistrar reg2 = loc2.getRegistrar();
        
        Object admin1 = null, admin2 = null;
        
        if (reg1 instanceof Administrable) {
            admin1 = ((Administrable) reg1).getAdmin();
        } else {
            System.err.println("Registrar " + reg1 + 
			       " is not administrable");
            return false;
        }
        
        if (reg2 instanceof Administrable) {
            admin2 = ((Administrable) reg2).getAdmin();
        } else {
            System.err.println("Registrar " + reg2 + 
			       " is not administrable");
            return false;
        }
        
        if (!(admin1 instanceof JoinAdmin)) {
            System.err.println("Registrar " + reg1 + 
                               " doesn't support " +
			       "join administration");
            return false;
        }
        if (!(admin2 instanceof JoinAdmin)) { 
            System.err.println("Registrar " + reg2 + 
                               " doesn't support " +
			       "join administration");
            return false;
        }
        
        JoinAdmin jadmin1 = (JoinAdmin) admin1;
        JoinAdmin jadmin2 = (JoinAdmin) admin2;
        
        // now, actually do the federation
        LookupLocator[] locs = new LookupLocator[1];
        
        locs[0] = loc1;
        jadmin2.addLookupLocators(locs);
        
        locs[0] = loc2;
        jadmin1.addLookupLocators(locs);
        
        return true;
    }
    
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: Federate " +
	                       "<url1> <url2>");
            System.exit(1);
        }
        
        String url1 = args[0], url2 = args[1];

        Federate fed = new Federate();
        
        try {
            if (fed.federate(url1, url2)) {
                System.out.println(
                        "Lookup services federated!");
            } else {
                System.err.println(
                        "Couldn't federate.");
            }
        } catch (Exception ex) {
            System.err.println("Error federating: " +
                               ex.getMessage());
        }
    }
}
