// A basic wrapper that uses JoinManager

package corejini.chapter8;

import net.jini.core.lookup.ServiceID;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.lookup.JoinManager;
import net.jini.lookup.ServiceIDListener;
import net.jini.discovery.LookupDiscoveryManager;
import java.io.File;
import java.io.Serializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.FileInputStream;
import java.io.ObjectOutputStream;
import java.io.FileOutputStream;
import java.rmi.RMISecurityManager;

class MyProxy implements Serializable, 
    corejini.chapter5.HelloWorldServiceInterface {
    
    public MyProxy() { }
    public String getMessage() {
        return "Bonjour, my little turnip...";
    }
}

public class ServiceWrapper implements Runnable {
    protected JoinManager join = null;
    protected File serFile = null;
    protected Object proxy = new MyProxy();
   
    // note static!
    static class PersistentData implements Serializable {
        ServiceID serviceID;
        Entry[] attrs;
        String[] groups;
        LookupLocator[] locators;
        
        public PersistentData() { 
        }
    }
    
    // An inner class to catch ID changes
    class IDListener implements ServiceIDListener {
        public void serviceIDNotify(ServiceID serviceID) {
            System.out.println("Got service ID " + serviceID);
            PersistentData state = new PersistentData();
            state.serviceID = serviceID;
            state.attrs = join.getAttributes();
            LookupDiscoveryManager luMgr =
                (LookupDiscoveryManager) join.getDiscoveryManager();
            state.groups = luMgr.getGroups();
            state.locators = luMgr.getLocators();
        
            try {
                writeState(state);
            } catch (IOException ex) {
                System.err.println("Couldn't write to file: " +
                                   ex.getMessage());
                ex.printStackTrace();
                join.terminate();
                System.exit(1);
            }
        }
    }
    
    public ServiceWrapper(File serFile, 
			  boolean firsttime) 
            throws IOException, ClassNotFoundException {
        this.serFile = serFile;

	if (System.getSecurityManager() == null) {
	    System.setSecurityManager(
		     new RMISecurityManager());
        }
        
        if (firsttime)
            register();
        else
            reregister();
    }
    
    public void run() {
        while (true) {
            try {
                Thread.sleep(Long.MAX_VALUE);
            } catch (InterruptedException ex) {
            }
        }
    }
    
    protected void register() throws IOException {
        if (join != null) {
            throw new IllegalStateException(
			   "Wrapper already started.");
        }
        
        
        System.out.println("Starting...");
        LookupDiscoveryManager luMgr =
            new LookupDiscoveryManager(new String[]{ "" },
                                       null,
                                       null);
        join = new JoinManager(proxy, null, 
			       new IDListener(), luMgr, null);
    }
    
    protected void reregister() 
	    throws IOException, ClassNotFoundException {
        if (join != null) {
            throw new IllegalStateException(
			    "Wrapper already started.");
        }
        
        PersistentData state = readState();
        
        System.out.println("Restarting:  old id is " + 
			   state.serviceID);
        
        LookupDiscoveryManager luMgr =
            new LookupDiscoveryManager(state.groups,
                                       state.locators,
                                       null);
        join = new JoinManager(proxy, state.attrs,
                               state.serviceID, luMgr, null);
    }

    protected void writeState(PersistentData state) throws IOException {
        ObjectOutputStream out = 
            new ObjectOutputStream(new FileOutputStream(serFile));
        
        out.writeObject(state);
        out.flush();
        out.close();
    }
    
    protected PersistentData readState() 
        throws IOException, ClassNotFoundException {
        ObjectInputStream in =
            new ObjectInputStream(
		new FileInputStream(serFile));
        
        PersistentData state = (PersistentData) 
	    in.readObject();
        in.close();
        return state;
    }
    
    static void usage() {
        System.err.println("Usage: ServiceWrapper " +
			   "[-f] serialization_file");
        System.exit(1);
    }
    
    public static void main(String[] args) {
        boolean firsttime = false;
        String serFileName = null;
        File serFile = null;
        
        if (args.length < 1 || args.length > 2) {
            usage();
        }
        
        if (args.length == 2) {
            if (args[0].equals("-f")) {
                firsttime = true;
                serFileName = args[1];
            } else {
                usage();
           }
        } else {
            serFileName = args[0];
        }
        
        serFile = new File(serFileName);
        
        try {
            ServiceWrapper wrapper = 
		new ServiceWrapper(serFile, firsttime);
            new Thread(wrapper).start();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}
