// An EntryBean to allow a Capacity entry to be 
// used via the bean conventions.  This version of 
// CapacityBean is a GUI object.

package corejini.chapter7;

import net.jini.core.entry.Entry;
import net.jini.lookup.entry.EntryBean;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.BoxLayout;

public class CapacityBean extends JPanel 
    implements EntryBean, Serializable {
    protected Capacity assoc = null;
    
    public CapacityBean() {
        super(true);
        setBackground(java.awt.Color.white);
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        add(new JLabel("Not initialized"));
    }
    
    public Entry followLink() {
        return assoc;
    }
    public void makeLink(Entry e) {
        if (e != null && !(e instanceof Capacity)) {
            throw new ClassCastException(
                    "Expected Capacity");
        }
        
        assoc = (Capacity) e;
        
        init();
    }
    
    protected void init() {
        // clear out anything lingering from a previous init()
        removeAll();
        
        JLabel label = new JLabel("Max = " + 
                                  getMaxCapacity() +
                                  ", used = " + 
                                  getInUse() +
                                  ", free = " + 
                                  getFreeSpace());
        JProgressBar slider = 
            new JProgressBar(0, getMaxCapacity().intValue());
        slider.setValue(getInUse().intValue());
        
        add(slider);
        add(label);
    }
    
    public Integer getMaxCapacity() {
        return assoc.maxCapacity;
    }
    public void setMaxCapacity(Integer maxCapacity) {
        assoc.maxCapacity = maxCapacity;
    }
    public Integer getInUse() {
        return assoc.inUse;
    }
    public void setInUse(Integer inUse) {
        assoc.inUse = inUse;
    }
    public Integer getFreeSpace() {
        return assoc.freeSpace;
    }
    public void setFreeSpace(Integer freeSpace) {
        assoc.freeSpace = freeSpace;
    }
}
