// A simple EntryBean to allow a Capacity entry 
// to be used via the bean conventions.

package corejini.chapter7;

import net.jini.core.entry.Entry;
import net.jini.lookup.entry.EntryBean;
import java.io.Serializable;

public class CapacityBean 
    implements EntryBean, Serializable {
    protected Capacity assoc = null;
    
    public CapacityBean() {
    }
    
    public Entry followLink() {
        return assoc;
    }
    public void makeLink(Entry e) {
        if (e != null && !(e instanceof Capacity)) {
            throw new ClassCastException(
                    "Expected Capacity");
        }
        
        assoc = (Capacity) e;
    }
    
    public Integer getMaxCapacity() {
        return assoc.maxCapacity;
    }
    public void setMaxCapacity(Integer maxCapacity) {
        assoc.maxCapacity = maxCapacity;
    }
    public Integer getInUse() {
        return assoc.inUse;
    }
    public void setInUse(Integer inUse) {
        assoc.inUse = inUse;
    }
    public Integer getFreeSpace() {
        return assoc.freeSpace;
    }
    public void setFreeSpace(Integer freeSpace) {
        assoc.freeSpace = freeSpace;
    }
}
