// An entry that represents some abstract capacity.

package corejini.chapter7;

import net.jini.entry.AbstractEntry;
import net.jini.lookup.entry.ServiceControlled;

// note we break out all three variables--even though any one can
// be computed from any other two.

public class Capacity extends AbstractEntry 
    implements ServiceControlled {
    public Integer maxCapacity;
    public Integer inUse;
    public Integer freeSpace;
    
    public Capacity() {
        maxCapacity = new Integer(0);
        inUse = new Integer(0);
        freeSpace = new Integer(0);
    }
    
    public Capacity(int max, int used) {
        maxCapacity = new Integer(max);
        inUse = new Integer(used);
        freeSpace = new Integer(max - used);
    }
}
