// Implement the unicast protocol "by hand"

package corejini.chapter6;

// look ma, no discovery packages.
import net.jini.core.lookup.ServiceRegistrar;
import java.net.Socket;
import java.rmi.MarshalledObject;
import java.io.DataOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;

public class Unicast {
    public static final int protoVersion = 1;
    
    public Unicast() {
    }
    
    public ServiceRegistrar getRegistrar(String host, int port) 
    throws IOException, ClassNotFoundException {
        Socket sock = new Socket(host, port);

        // send the request
        DataOutputStream out = 
            new DataOutputStream(sock.getOutputStream());
        out.writeInt(protoVersion);
        out.flush();
        
        // receive the reply
        ObjectInputStream in = 
            new ObjectInputStream(sock.getInputStream());
        MarshalledObject mobj = 
            (MarshalledObject) in.readObject();
        
        System.out.println("Received serialized proxy " +
                           "from registrar.");
        
        int groupLen = in.readInt();
        String[] groups = new String[groupLen];
        
        System.out.println("Registrar supports " + 
                           groupLen + " groups.");
        for (int i=0 ; i<groupLen ; i++) {
            groups[i] = in.readUTF();
            System.out.println("Group " + i + ": " + 
                               groups[i]);
        }
        
        // Convert the marshalled object into a "live" registrar
        ServiceRegistrar reg = 
            (ServiceRegistrar) mobj.get();

        return reg;
    }
    
    public static void main(String[] args) {
        String host = null;
        int port = 4160;
        
        if (args.length >= 1) {
            host = args[0];
        }
        if (args.length == 2) {
            try {
                port = Integer.parseInt(args[1]);
            } catch (NumberFormatException ex) {
                System.err.println("Expected a numerical port: " + 
                                   ex.getMessage());
                System.exit(1);
            }
        }
        if (args.length == 0 || args.length > 2) {
            System.err.println("Usage: Unicast <host> [<port>]");
            System.exit(1);
        }
        
        Unicast unicast = new Unicast();
        ServiceRegistrar reg;
        
        try {
            reg = unicast.getRegistrar(host, port);
            
            System.out.println("Got registrar: ");
            System.out.println("\tURL:    " + 
                               PrintingListener.getURL(reg));
            System.out.println("\tID:     " + 
                               reg.getServiceID());
            System.out.println("\tGroups: " + 
                               PrintingListener.getGroups(reg));
        } catch (Exception ex) {
            System.err.println("Error getting lookup proxy: " +
                               ex.getMessage());
            ex.printStackTrace();
        }
    }
}
