// Exercise the LookupLocator class

package corejini.chapter6;

import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;

public class LocatorExample {
    public LocatorExample() {
    }
    
    public ServiceRegistrar getRegistrar(String url) 
        throws MalformedURLException, IOException, 
                ClassNotFoundException {
        LookupLocator loc = new LookupLocator(url);
        System.out.println("Host: " + loc.getHost());
        System.out.println("Port: " + loc.getPort());
        return loc.getRegistrar();
    }
    
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage:  LocatorExample <URL>");
            System.exit(1);
        }
        
        LocatorExample loc = new LocatorExample();
        ServiceRegistrar reg;
        
        try {
            reg = loc.getRegistrar(args[0]);
        
            System.out.println("Got registrar: ");
            System.out.println("\tURL:    " + 
                               PrintingListener.getURL(reg));
            System.out.println("\tID:     " + 
                               reg.getServiceID());
            System.out.println("\tGroups: " + 
                               PrintingListener.getGroups(reg));
        } catch (MalformedURLException ex) {
            System.err.println("Not a valid jini URL.");
            System.exit(1);
        } catch (Exception ex) {
            System.err.println("Error getting proxy: " +
                               ex.getMessage());
            System.exit(1);
        }
    }
}
