// Exercise the DiscoveryListener class through
// LookupDiscoveryManager

package corejini.chapter6;

import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.core.lookup.ServiceRegistrar;
import java.util.ArrayList;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.net.MalformedURLException;
import java.io.IOException;

public class DiscoveryExample {
    protected LookupDiscoveryManager discoveryMgr = null;
    protected DiscoveryListener myListener;
    protected String[] groups;
    protected LookupLocator[] locs;
    
    public DiscoveryExample(ArrayList groups, ArrayList locs) {
	// To mirror the DiscoveryGroupManagement constants,
	// an empty groups array indicates NO_GROUPS, while a
	// null groups array indicates ALL_GROUPS.
	if (groups == null) {
	    System.out.println("searching for all groups");
            this.groups = 
		DiscoveryGroupManagement.ALL_GROUPS;
	} else if (groups.size() == 0) {
            System.out.println("searching for no groups");
            this.groups = 
		DiscoveryGroupManagement.NO_GROUPS;
        } else {
            this.groups = (String[]) 
                groups.toArray(new String[0]);
        }
        this.locs = (LookupLocator[]) 
            locs.toArray(new LookupLocator[0]);
    }
   
    synchronized void startDiscovery() throws IOException {
        if (discoveryMgr == null) {
            discoveryMgr = new LookupDiscoveryManager(groups,
                                                      locs, null);
	    myListener = new PrintingListener(discoveryMgr);
            discoveryMgr.addDiscoveryListener(myListener);
        }
    }
    
    synchronized void stopDiscovery() throws IOException {
        if (discoveryMgr != null) {
            discoveryMgr.terminate();
        }
    }
    
    public static void main(String[] args) {
        ArrayList groups = new ArrayList();
        ArrayList locs = new ArrayList();
        boolean doingGroups = false;
        int index = 0;

	if (System.getSecurityManager() == null) {
	    System.setSecurityManager(
		new RMISecurityManager());
	}
        
        try {
            for (int i=0 ; i<args.length ; i++) {
                if (args[i].equals("-groups")) {
                    doingGroups = true;
                } else {
                    if (doingGroups) {
                        if (args[i].equals("public")) {
                            groups.add("");
                        } else if (args[i].equals("none")) {
			    // make it an empty arraylist
                            groups.clear();
			    break;
			} else if (args[i].equals("all")) {
			    // make it a null array list.
			    groups = null;
			    break;
                        } else {
                            groups.add(args[i]);
                        }
                    } else {
                        locs.add(new LookupLocator(args[i]));
                    }
                }
            }
            
            DiscoveryExample ex = 
			new DiscoveryExample(groups, locs);
            ex.startDiscovery();
        
            System.out.println("Hit return to terminate " +
				"discovery.");
        
            while (((char) System.in.read()) != '\n')
                /* loop */ ;
        
            System.out.println("Terminating discovery.");
            ex.stopDiscovery();
        } catch (MalformedURLException ex) {
            System.err.println("Bad URL: " +
				ex.getMessage());
        } catch (IOException ex) {
            System.err.println("Problems with discovery: " + 
				ex.getMessage());
        }
    }
}
