// A "smarter" proxy for the hello world service. 
// This one knows how to talk to a remote object
// that implements the BackendProtocol interface.

package corejini.chapter5;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;

public class HelloWorldServiceProxy2 
    implements HelloWorldServiceInterface,
             Serializable {
    protected BackendProtocol backend;
    
    public HelloWorldServiceProxy2() {
    }
    
    public HelloWorldServiceProxy2(BackendProtocol backend) {
        this.backend = backend;
    }
    
    // Note getMessage() now calls backend.fetchString()
    public String getMessage() {
        try {
            System.out.println("Proxy calling backend...");
            return backend.fetchString();
        } catch (RemoteException ex) {
            return "Couldn't contact backend: " +
                ex.getMessage();
        }
    }
    
} 
