// Extend the client to renew its event registration
// leases.

package corejini.chapter5;

import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.EventRegistration;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import java.util.ArrayList;
import java.io.IOException;
import java.rmi.RemoteException;

public class HelloWorldClientWithLeases 
    extends HelloWorldClientWithEvents {
    protected ArrayList eventRegs = new ArrayList();
    protected Thread leaseThread = null;
    
    public HelloWorldClientWithLeases() 
        throws RemoteException, IOException {
    }

    // When we register for events, add the event's
    // registration to the set of managed
    // registrations.
    protected void registerForEvents(ServiceRegistrar lu) 
        throws RemoteException {
        EventRegistration evreg;
        
        evreg = lu.notify(template, 
                          ServiceRegistrar.TRANSITION_NOMATCH_MATCH,
                          eventCatcher, null, LEASE_TIME);
        
        eventRegs.add(evreg);
        leaseThread.interrupt();
    }
        
    // run maintains our leases
    public void run() {
        while (true) {
            try {
                long sleepTime = computeSleepTime();
                Thread.sleep(sleepTime);
                renewLeases();
            } catch (InterruptedException ex) {
            }
        }
    }

    // Figure out how long to sleep.
    protected synchronized long computeSleepTime() {
        long soonestExpiration = Long.MAX_VALUE;
        for (int i=0, size=eventRegs.size() ; i<size ; i++) {
            Lease l = ((EventRegistration) 
                       eventRegs.get(i)).getLease();
            if (l.getExpiration() - (20 * 1000) < soonestExpiration) {
                soonestExpiration = l.getExpiration() - (20 * 1000);
            }
        }
            
        long now = System.currentTimeMillis();
        
        if (now >= soonestExpiration) {
            return 0;
        } else {
            return soonestExpiration - now;
        }
    }
    
    // Do the lease renewal work.
    protected synchronized void renewLeases() {
        long now = System.currentTimeMillis();
        ArrayList deadLeases = new ArrayList();
        
        for (int i=0 , size=eventRegs.size() ; i<size ; i++) {
            Lease l = ((EventRegistration) 
                       eventRegs.get(i)).getLease();
            if (now <= l.getExpiration() &&
                now >= l.getExpiration() - (20 * 1000)) {
                try {
                    System.out.println("Renewing lease.");
                    l.renew(LEASE_TIME);
                } catch (Exception ex) {
                    System.err.println("Couldn't renew lease: " +
                                       ex.getMessage());
                    deadLeases.add(eventRegs.get(i));
                }
            }
        }
        
        // clean up after any leases that died
        for (int i=0, size=deadLeases.size() ; i<size ; i++) {
            eventRegs.remove(deadLeases.get(i));
        }
    }
    
    // Start the service.
    public static void main(String args[]) {
        try {
            HelloWorldClientWithLeases hwc = 
                new HelloWorldClientWithLeases();
            hwc.leaseThread = new Thread(hwc);
            hwc.leaseThread.start();
        } catch (IOException ex) {
            System.out.println("Couldn't create client: " +
                               ex.getMessage());
        }
    }
}
