// Extend the client so that it can receive events
// when new services appear.

package corejini.chapter5;

import net.jini.core.lookup.ServiceEvent;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class HelloWorldClientWithEvents extends HelloWorldClient {
    protected final int LEASE_TIME = 10 * 60 * 1000; // 10 minutes
    
    // An inner class to listen for events.
    class MyEventListener 
        extends UnicastRemoteObject 
        implements RemoteEventListener {
        public MyEventListener() throws RemoteException {
        }
        
        // Called when an event is received.
        public void notify(RemoteEvent ev) 
            throws RemoteException, UnknownEventException {
            System.out.println("Got an event from: " + ev.getSource());
            if (ev instanceof ServiceEvent) {
                ServiceEvent sev = (ServiceEvent) ev;
                ServiceItem item = sev.getServiceItem();
                HelloWorldServiceInterface hws =
                    (HelloWorldServiceInterface) item.service;
                
                System.out.println("Got a matching service.");
                System.out.println("It's message is: " +
                                   hws.getMessage());
            } else {
                System.out.println("Not a service event, " +
                                   "ignoring");
            }
        }
    }
    
    protected MyEventListener eventCatcher;
    
    // Same as superclass, only create an event
    // listener
    public HelloWorldClientWithEvents() 
        throws RemoteException, IOException {
        eventCatcher = new MyEventListener();
    }
    
    protected Object lookForService(ServiceRegistrar lu) {
        Object o = super.lookForService(lu);

        try {
            registerForEvents(lu);
        } catch (RemoteException ex) {
            System.err.println("Can't solicit events: "
                               + ex.getMessage());
            // Discard it, so we can find it again
            disco.discard(lu);
        }
        
        return o;
    }
    
    // Ask for events from the lookup service
    protected void registerForEvents(ServiceRegistrar lu) 
        throws RemoteException {
        lu.notify(template, 
                  ServiceRegistrar.TRANSITION_NOMATCH_MATCH,
                  eventCatcher, null, LEASE_TIME);
    }
    
    // Start the client.
    public static void main(String args[]) {
        try {
            HelloWorldClientWithEvents hwc = 
                new HelloWorldClientWithEvents();
            new Thread(hwc).start();
        } catch (IOException ex) {
            System.out.println("Couldn't create client: " +
                               ex.getMessage());
        }
    }
}
