// This client loads a serialized mailbox off of 
// disk receives events from it.

package corejini.chapter19;

import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.event.MailboxRegistration;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.FileInputStream;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.server.UnicastRemoteObject;

public class EmptyMailbox  {
    private MailboxRegistration mbox;
    
    static class LogListener extends UnicastRemoteObject 
	implements RemoteEventListener {
	LogListener() throws RemoteException {
	}

        public void notify(RemoteEvent ev) {
            System.out.println("Received event from mailbox: ");
            System.out.println("    " + ev);
            System.out.println("    " + ev.getClass().getName());
        }
    }
    
    public EmptyMailbox(String filename) throws Exception {
        File file = new File(filename);
        ObjectInputStream in = 
            new ObjectInputStream(
                new FileInputStream(file));
        
        MarshalledObject mobj = (MarshalledObject) in.readObject();

	mbox = (MailboxRegistration) mobj.get();
    }
    
    public void receiveEvents() throws RemoteException {
        mbox.enableDelivery(new LogListener());
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.err.println("Usage: EmptyMailbox <file>");
                System.exit(1);
            }
            
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            
            EmptyMailbox empty = new EmptyMailbox(args[0]);
	    System.out.println("Receiving events...");
            empty.receiveEvents();
        } catch (Exception ex) {
            System.err.println("Error: " + ex.getMessage());
            ex.printStackTrace();
        }
    }
} 
