// An Entry that represents a ServiceEvent.

package corejini.chapter17;

import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceEvent;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.Name;

public class ServiceEventEntry extends WatcherEntry {
    public ServiceRegistrar registrar = null;
    public ServiceID serviceID = null;
    // even though these details can be fetched 
    // from the service item, breaking them out
    // allows independent searching.
    public ServiceItem serviceItem = null;
    public Object service = null;
    public Integer transition = null;
    public String name = null;
    
    public ServiceEventEntry() {
    }
    
    public ServiceEventEntry(String group, ServiceEvent ev) {
        super(group, System.currentTimeMillis());
        
        registrar = (ServiceRegistrar) ev.getSource();
        serviceID = ev.getServiceID();
        serviceItem = ev.getServiceItem();
        transition = new Integer(ev.getTransition());
        if (serviceItem != null) {
            service = serviceItem.service;
        
            // Attach the Name as a separate member, if
            // there is one.
            Entry[] attrs = serviceItem.attributeSets;
        
            for (int i=0 ; i<attrs.length ; i++) {
                if (attrs[i] instanceof Name) {
                    name = ((Name) attrs[i]).name;
                }
            }
        }
    }
}

