// An Entry class that represents a DiscoveryEvent

package corejini.chapter17;

import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.discovery.LookupLocator;
import java.rmi.RemoteException;

public class DiscoveryEventEntry extends WatcherEntry {
    public ServiceRegistrar reg;
    public LookupLocator locator = null;
    public Boolean discovered = null;
    
    public DiscoveryEventEntry() {
    }
    
    public DiscoveryEventEntry(String group,
                               ServiceRegistrar reg,
                               boolean discovered) {
        super(group, System.currentTimeMillis());
        
        this.reg = reg;
        try {
            this.locator = reg.getLocator();
        } catch (RemoteException ex) {
        }
        this.discovered = new Boolean(discovered);
    }
}
