// This class represents one event registration
// with a BasicRegistrationLandlord
package corejini.chapter16;

import net.jini.core.event.RemoteEventListener;
import java.io.Serializable;
import java.rmi.MarshalledObject;

class Registration implements Serializable {
    protected Object cookie;
    protected RemoteEventListener listener;
    protected MarshalledObject data;
    protected long expiration;

    // To maintain a registration we need to remember
    // the cookie for the registration, who the listener
    // is, the client-provided data, and its expiration
    // time.
    Registration(Object cookie, RemoteEventListener listener,
                 MarshalledObject data, long expiration) {
        this.cookie = cookie;
        this.listener = listener;
        this.data = data;
        this.expiration = expiration;
    }
    
    Object getCookie() {
        return cookie;
    }
    RemoteEventListener getListener() {
        return listener;
    }
    MarshalledObject getData() {
        return data;
    }
    long getExpiration() {
        return expiration;
    }
    void setExpiration(long expiration) {
        this.expiration = expiration;
    }
    
    // Subclasses can override this if they need to do special things
    // at cancellation/expiration time.  The default implementation
    // does nothing.
    protected void cancelled() {
    }
}
