// A simple client to test the HeartbeatGenerator
// service.

package corejini.chapter16;

import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceEvent;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseListener;
import net.jini.core.lease.Lease;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.server.UnicastRemoteObject;

public class HeartbeatClient implements Runnable { 
    ServiceTemplate template;
    HeartbeatGenerator.HeartbeatRequest 
		gen = null;
    LeaseRenewalManager leaseManager = 
		new LeaseRenewalManager();
    EvtListener listener;
  
    // An inner class for discovery listening
    public class DiscListener implements DiscoveryListener {
        public void discovered(DiscoveryEvent ev) {
            ServiceRegistrar[] regs = ev.getRegistrars();
            for (int i=0 ; i<regs.length ; i++) {
                doit(regs[i]);
            }
        }
        public void discarded(DiscoveryEvent ev) {
        }
    }

    // an inner class for event listening 
    class EvtListener extends UnicastRemoteObject 
        implements RemoteEventListener {
        EvtListener() throws RemoteException {
        }
        public void notify(RemoteEvent e) {
            if (!(e instanceof HeartbeatGenerator.HeartbeatEvent)) {
                return;
            }
            HeartbeatGenerator.HeartbeatEvent ev = 
                (HeartbeatGenerator.HeartbeatEvent) e;
            
            switch (ev.getPeriod()) {
            case HeartbeatGenerator.MINUTE:
                System.out.println("Came from MINUTE");
                break;
            case HeartbeatGenerator.HOUR:
                System.out.println("Came from HOUR");
                break;
            case HeartbeatGenerator.DAY:
                System.out.println("Came from DAY");
                break;
            case HeartbeatGenerator.WEEK:
                System.out.println("Came from WEEK");
                break;
            default:
                System.out.println("Unknown!");
                break;
            }
        }
    }
    
    public HeartbeatClient() throws IOException, 
			RemoteException {
        Class[] types = 
		{ HeartbeatGenerator.HeartbeatRequest.class };
        template = new ServiceTemplate(null, types, null);
        
        listener = new EvtListener();
        
        LookupDiscoveryManager luMgr =
            new LookupDiscoveryManager(
		    DiscoveryGroupManagement.ALL_GROUPS,
                    null, null);
        luMgr.addDiscoveryListener(new DiscListener());
    }
    
    void doit(ServiceRegistrar reg) {
        if (gen != null)  // bail once we've found it.
            return;
        
        try {
            gen = (HeartbeatGenerator.HeartbeatRequest)
                reg.lookup(template);
        } catch (Exception ex) {
            System.err.println("Doing lookup: " + 
				ex.getMessage());
        }
        
        if (gen == null)
            return;
        
        // sign us up for events!
        EventRegistration evt;
        try {
            evt = gen.register(HeartbeatGenerator.MINUTE, 
			       null, listener, Lease.ANY);
            leaseManager.renewUntil(evt.getLease(), 
				    Lease.ANY, null);
            
            evt = gen.register(HeartbeatGenerator.HOUR, 
			       null, listener, Lease.ANY);
            leaseManager.renewUntil(evt.getLease(), 
				    Lease.ANY, null);
            
            evt = gen.register(HeartbeatGenerator.DAY, 
			       null, listener, Lease.ANY);
            leaseManager.renewUntil(evt.getLease(), 
				    Lease.ANY, null);
            
            evt = gen.register(HeartbeatGenerator.WEEK, 
			       null, listener, Lease.ANY);
            leaseManager.renewUntil(evt.getLease(), 
				    Lease.ANY, null);
            
        } catch (RemoteException ex) {
            System.err.println("Bogus: " + ex.getMessage());
        }
    }
   
    public void run() {
        while (true) {
            try {
                Thread.sleep(Integer.MAX_VALUE);
            } catch (InterruptedException ex) {
            }
        }
    }

    public static void main(String[] args) {
	if (System.getSecurityManager() == null) {
	    System.setSecurityManager(
		new RMISecurityManager());
	} 

        try {
            HeartbeatClient client = new HeartbeatClient();
            new Thread(client).start();
        } catch (Exception ex) {
            System.err.println("Bogus: " + ex.getMessage());
            System.exit(1);
        }
    }
}


