// A subclass of registration that holds a
// vector of to-be-delivered events.

package corejini.chapter16;

import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.List;
import java.util.ArrayList;

class EventMailboxRegistration 
    extends Registration implements Serializable {
    protected List mailbox = new ArrayList();
    
    EventMailboxRegistration(Object cookie, 
                             RemoteEventListener listener,
                             MarshalledObject data, 
                             long expiration) {
        super(cookie, listener, data, expiration);
    }
    
    // Override cancelled to null the mailbox
    protected void cancelled() {
        mailbox = null;
    }
    
    List getMailbox() {
        return mailbox;
    }
    void appendEvent(RemoteEvent ev) {
        mailbox.add(ev);
    }
    List getAndFlushMailbox() {
        List rv = getMailbox();
        mailbox = new ArrayList();
        return rv;
    }
}
