// A remote event that signals printer completion/failure

package corejini.chapter15;

import net.jini.core.event.RemoteEvent;
import java.io.Serializable;

public class PrintServiceEvent extends RemoteEvent 
    implements Serializable  {
    protected Exception ex;

    PrintServiceEvent(PrintProxy proxy, long seq, Exception ex) {
        super(proxy, 0 /* type */, seq, null);
        this.ex = ex;
    }
    
    public Exception getException() {
        return ex;
    }
    public boolean printJobFinished() {
        return ex == null;
    }
}

