// This is the actual proxy object that will be sent to clients.

package corejini.chapter15;

import net.jini.admin.Administrable;
import net.jini.core.event.RemoteEventListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.awt.print.PageFormat;

public class PrintProxy implements Serializable, 
    Administrable, Printer {
    protected RemotePrinter remote;
    
    PrintProxy(RemotePrinter remote) {
        this.remote = remote;
    }
    
    public void print(int format, int copies, Object data,
                      RemoteEventListener listener) 
        throws RemoteException {
        switch (format) {
        case PageFormat.LANDSCAPE:
        case PageFormat.PORTRAIT:
        case PageFormat.REVERSE_LANDSCAPE:
            break;
        default:
            throw new 
                IllegalArgumentException("Bogus page format");
        }
        
        if (data == null) {
            throw new NullPointerException("data");
        }
        
        remote.print(format, copies, data, listener);
    }
    public Object getAdmin() throws RemoteException {
        return remote.getAdmin();
    }
    public boolean equals(Object o) {
        if (o instanceof PrintProxy) {
            return ((PrintProxy) o).remote.equals(remote);
        } else {
            return false;
        }
    }

    // Two objects that are equals() must have the same hashCode()
    // value.  So here I override hashCode() to return the hash
    // code of the remote object.
    public int hashCode() {
	return remote.hashCode();
    }
}

