// A user interface for PrintAdmin objects.

package corejini.chapter15;

import net.jini.core.entry.Entry;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JLabel;
import java.util.List;
import java.rmi.RemoteException;

public class PrintAdminPanel implements Entry {
    private JPanel panel = null;

    public PrintAdminPanel() {
    }

    public JPanel getPanel() {
	return panel;
    }
    
    public void setAdmin(final PrintAdmin admin) {
	panel = new JPanel();

        panel.setLayout(new BorderLayout());
        panel.add(new JLabel("Current Print Jobs"), "North");
        
        final JList list = new JList();
        panel.add(list, "Center");
        
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) {
                List jobs = null;
                try {
                    jobs = admin.getJobs();
                    System.out.println("Got back " + jobs.size() + " jobs");
                } catch (RemoteException ex) {
                    System.err.println("Error getting jobs: " +
                                       ex.getMessage());
                }
                list.setListData(jobs.toArray(new Object[0]));
            }
        });
        
        panel.add(refreshButton, "South");
        
        refreshButton.doClick();
    }
}

