// client-visible representation of a job

package corejini.chapter15;

import java.io.Serializable;
import java.awt.print.PageFormat;

public class JobRecord implements Serializable {
    boolean current;
    int format;
    int copies;
    String dataName;
    int jobid;

    JobRecord(PrintRecord rec, boolean current) {
        this.current = current;
        this.format = rec.format;
        this.copies = rec.copies;
        this.dataName = rec.data.toString();
        this.jobid = rec.hashCode();
    }

    public boolean getCurrent() {
        return current;
    }

    public int getFormat() {
        return format;
    }

    public int getCopies() {
        return copies;
    }

    public String getDataName() {
        return dataName;
    }

    public int getJobID() {
        return jobid;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();

        if (current) {
            buf.append("[CURRENT] ");
        }
        switch (format) {
        case PageFormat.PORTRAIT:
            buf.append("portrait, ");
            break;
        case PageFormat.LANDSCAPE:
            buf.append("landscape, ");
            break;
        case PageFormat.REVERSE_LANDSCAPE:
            buf.append("reverse, ");
            break;
        }
        buf.append(copies + " copies, ");
        buf.append(dataName);

        return buf.toString();
    }
}

