// A class for handling common administrative chores.

package corejini.chapter15;

import net.jini.lookup.JoinManager;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.core.entry.Entry;
import net.jini.core.discovery.LookupLocator;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.io.File;
import java.io.IOException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;

public class BasicUnicastAdmin extends UnicastRemoteObject
    implements RemoteUnicastAdmin {
    protected BasicUnicastService service;
    
    protected BasicUnicastAdmin(BasicUnicastService service) 
        throws RemoteException {
        this.service = service;
    }
    
    public synchronized void destroy() {
        File locFile = new File(service.storageLoc);
        service.getJoinManager().terminate();
        locFile.delete();
        service.shutdown();
    }
    
    public synchronized void setStorageLocation(String loc) 
        throws RemoteException {
        try {
            File newLocFile = new File(loc);
            File oldLocFile = new File(service.storageLoc);
                
            BufferedReader reader =
                new BufferedReader(new FileReader(oldLocFile));
            BufferedWriter writer =
                new BufferedWriter(new FileWriter(newLocFile));
                
            char[] buffer = new char[1024];
            int n;
            while ((n = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, n);
            }
            reader.close();
            writer.close();
                
            service.storageLoc = loc;
            oldLocFile.delete();
        } catch (IOException ex) {
            throw new RemoteException(ex.toString());
        }
    }
    public String getStorageLocation() {
        return service.storageLoc;
    }
    public Entry[] getLookupAttributes() {
        return service.getJoinManager().getAttributes();
    }
    public void addLookupAttributes(Entry[] attrs)
        throws RemoteException {
        service.getJoinManager().addAttributes(attrs, true);
        try {
            service.checkpoint();
        } catch (IOException ex) {
            throw new RemoteException(ex.toString());
        }
    }
    public void modifyLookupAttributes(Entry[] tmpls,
                                       Entry[] attrs)
        throws RemoteException {
        service.getJoinManager().modifyAttributes(tmpls, attrs, true);
        try {
            service.checkpoint();
        } catch (IOException ex) {
            throw new RemoteException(ex.toString());
        }
    }
    public String[] getLookupGroups() {
        return service.getDiscoveryManager().getGroups();
    }
    public void addLookupGroups(String[] groups) 
        throws RemoteException {
        try {
            service.getDiscoveryManager().addGroups(groups);
        } catch (IOException ex) {
        }
        try {
            service.checkpoint();
        } catch (IOException ex) {
            throw new RemoteException(ex.toString());
        }
    }
    public void removeLookupGroups(String[] groups) 
        throws RemoteException {
        service.getDiscoveryManager().removeGroups(groups);
        try {
            service.checkpoint();
        } catch (IOException ex) {
            throw new RemoteException(ex.toString());
        }
    }
    public void setLookupGroups(String[] groups)
        throws RemoteException {
        try {
            service.getDiscoveryManager().setGroups(groups);
        } catch (IOException ex) {
        }
        try {
            service.checkpoint();
        } catch (IOException ex) {
            throw new RemoteException(ex.toString());
        }
    }
    public LookupLocator[] getLookupLocators() {
        return service.getDiscoveryManager().getLocators();
    }
    public void addLookupLocators(LookupLocator[] locs) 
        throws RemoteException {
        service.getDiscoveryManager().addLocators(locs);
        try {
            service.checkpoint();
        } catch (IOException ex) {
            throw new RemoteException(ex.toString());
        }
    }
    public void removeLookupLocators(LookupLocator[] locs) 
        throws RemoteException {
        service.getDiscoveryManager().removeLocators(locs);
        try {
            service.checkpoint();
        } catch (IOException ex) {
            throw new RemoteException(ex.toString());
        }
    }
    public void setLookupLocators(LookupLocator[] locs)
        throws RemoteException {
        service.getDiscoveryManager().setLocators(locs);
        try {
            service.checkpoint();
        } catch (IOException ex) {
            throw new RemoteException(ex.toString());
        }
    }
}
