// A simple frame to display a splash screen

package corejini.chapter14;

import net.jini.admin.Administrable;
import net.jini.core.entry.Entry;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.ImageIcon;
import java.awt.event.WindowEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.IOException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.rmi.RemoteException;
import corejini.chapter11.AdminPanel;

public class SplashScreen extends JFrame implements Entry {
    protected final static String ICON = 
        "SplashScreen.gif";
    protected final static String DEFAULT = 
        "Core Jini / Leasing Service";
    
    public SplashScreen() {
        super("Uninitialized splash screen");
    }
    public SplashScreen(Object proxy) {
        super(proxy.getClass().getName());
        setProxy(proxy);
    }
   
    // Set the proxy object that the splash screen is for
    public void setProxy(Object proxy) {
	Object admin;

        if (proxy == null) {
            admin = null;
            return;
        }
        
        setTitle(proxy.getClass().getName());
        
        try {
            if (proxy instanceof Administrable) {
                admin = ((Administrable) proxy).getAdmin();
            } else {
		admin = null;
	    }
        } catch (RemoteException ex) {
	    admin = null;
        }
        
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent ev) {
                setVisible(false);
                dispose();
            }
        });
        
        JLabel label;
        byte[] buffer = null;
       
	// Fetch the splash screen as a resource.  This gets it using
	// the same classloader that loaded this object.
        try {
            InputStream resource = getClass().getResourceAsStream(ICON);
            if (resource == null) {
                label = new JLabel(DEFAULT);
            } else {
                BufferedInputStream in =
                    new BufferedInputStream(resource);
                ByteArrayOutputStream out =
                    new ByteArrayOutputStream(1024);
                
                buffer = new byte[1024];
                int n;
                
                while ((n = in.read(buffer)) >  0) {
                    out.write(buffer, 0, n);
                }
                in.close();
                out.flush();
                
                buffer = out.toByteArray();
                
                if (buffer.length == 0) {
                    label = new JLabel(DEFAULT);
                } else {
                    label = 
                        new JLabel(new ImageIcon(buffer));
                }
            }
        } catch (IOException ex) {
            label = new JLabel(DEFAULT);
        }
        
        getContentPane().add(label, "Center");
        
        if (admin != null) {
	    final Object fadmin = admin;
            JButton button = new JButton("Admin");
            button.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent ev) {
                    JFrame frame = new JFrame("Lease Service Admin");
                    frame.getContentPane().add(new AdminPanel(fadmin),
                                               "Center");
                    frame.pack();
                    frame.addWindowListener(new WindowAdapter() {
                        public void windowClosing(WindowEvent ev) {
                            setVisible(true);
                            dispose();
                        }
                    });
                    frame.setVisible(true);
                }
            });
            getContentPane().add(button, "South");
        }
        
        pack();
        setVisible(true);
    }
}
