// this is the actual admin object that gets returned to clients.
package corejini.chapter14;

import net.jini.core.entry.Entry; 
import net.jini.core.discovery.LookupLocator;
import net.jini.admin.JoinAdmin;
import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.admin.StorageLocationAdmin;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;

public class LeaseAdminProxy implements JoinAdmin, DestroyAdmin, 
    StorageLocationAdmin, Serializable {
    protected AdminLeaseService.RemoteLeaseAdmin backend;
    
    LeaseAdminProxy(AdminLeaseService.RemoteLeaseAdmin backend) {
        this.backend = backend;
    }
    
    // implement destroyadmin
    public void destroy() throws RemoteException {
        backend.destroy();
    }
    
    // implement storagelocationadmin
    public void setStorageLocation(String loc) 
        throws IOException, RemoteException {
        backend.setStorageLocation(loc);
    }
    
    public String getStorageLocation() 
        throws RemoteException {
        return backend.getStorageLocation();
    }
    
    // implement JoinAdmin
    public Entry[] getLookupAttributes() 
        throws RemoteException {
        return backend.getLookupAttributes();
    }
    public void addLookupAttributes(Entry[] attrs) 
        throws RemoteException {
        backend.addLookupAttributes(attrs);
    }
    public void modifyLookupAttributes(Entry[] tmpls, 
                                       Entry[] attrs)
        throws RemoteException {
        backend.modifyLookupAttributes(tmpls, attrs);
    }
    public String[] getLookupGroups() 
        throws RemoteException {
        return backend.getLookupGroups();
    }
    public void addLookupGroups(String[] groups) 
        throws RemoteException {
        backend.addLookupGroups(groups);
    }
    public void removeLookupGroups(String[] groups) 
        throws RemoteException {
        backend.removeLookupGroups(groups);
    }
    public void setLookupGroups(String[] groups) 
        throws RemoteException {
        backend.setLookupGroups(groups);
    }
    public LookupLocator[] getLookupLocators() 
        throws RemoteException {
        return backend.getLookupLocators();
    }
    public void addLookupLocators(LookupLocator[] locs) 
        throws RemoteException {
        backend.addLookupLocators(locs);
    }
    public void removeLookupLocators(LookupLocator[] locs) 
        throws RemoteException {
        backend.removeLookupLocators(locs);
    }
    public void setLookupLocators(LookupLocator[] locs) 
        throws RemoteException {
        backend.setLookupLocators(locs);
    }

    public boolean equals(Object o) {
	if (o instanceof LeaseAdminProxy) {
	    return backend.equals(((LeaseAdminProxy) o).backend);
	} else {
	    return false;
	}
    }
    public int hashCode() {
	return backend.hashCode();
    }
}
