// Extend the administrable lease service to attach a UI
// attribute to it.

package corejini.chapter14;

import net.jini.core.entry.Entry;
import net.jini.lookup.entry.ServiceInfo;
import java.io.IOException;
import java.rmi.RemoteException;

public class AttrLeaseService extends AdminLeaseService {
    public AttrLeaseService(String storageLoc) 
        throws RemoteException, IOException, 
                ClassNotFoundException {
        super(storageLoc);
        
        Entry[] entries = new Entry[2];
        
        entries[0] = new ServiceInfo("Prentice-Hall",
                                     "LeaseService",
                                     "LeaseService",
                                     null,
                                     "Prentice-Hall",
                                     "v1.0");
        entries[1] = new SplashScreen();
        
        joinMgr.addAttributes(entries);
	checkpoint();
    }
    
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: LeaseService <storage_loc>");
            System.exit(1);
        }
        
        try {
            AttrLeaseService src = 
                new AttrLeaseService(args[0]);
            while (!done) { 
                try {
                    thread = Thread.currentThread();
                    Thread.sleep(Long.MAX_VALUE);
                } catch (InterruptedException ex) {
                }
            }
        } catch (Exception ex) {
            System.err.println("Trouble starting: " + 
                               ex.getMessage());
            ex.printStackTrace();
        }
        System.exit(1);
    }
}
