// Administrable subclass of LeaseService

package corejini.chapter14;

import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.lookup.JoinManager;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import net.jini.admin.JoinAdmin;
import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.admin.StorageLocationAdmin;
import java.io.File;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import corejini.chapter12.LeaseService;

public class AdminLeaseService extends LeaseService {
    protected RemoteLeaseAdmin remoteAdmin = null;
    protected LeaseAdminProxy admin = null;
    protected static boolean done = false;  
    protected static Thread thread = null;  
    
    // work around bugs in javac's handling of inner classes and
    // inheritance
    JoinManager getJoinManager() {
        return joinMgr;
    }
    LeaseRenewalManager getLeaseManager() {
        return leaseMgr;
    }
    LookupDiscoveryManager getDiscoveryManager() {
        return (LookupDiscoveryManager) 
            joinMgr.getDiscoveryManager();
    }
    
    void setStorageLoc(String loc) {
        storageLoc = loc;
    }
    String getStorageLoc() {
        return storageLoc;
    }
   
    // All of our administrative interfaces
    public interface RemoteLeaseAdmin extends Remote, JoinAdmin,
        StorageLocationAdmin, DestroyAdmin {
    }

    public class RemoteLeaseAdminImpl extends UnicastRemoteObject 
        implements RemoteLeaseAdmin {
        RemoteLeaseAdminImpl() throws RemoteException {
            super();
        }
    
        public void destroy() {
            File locFile = new File(getStorageLoc());
            synchronized (AdminLeaseService.this) {
                // stop doing lookup/discovery
                getJoinManager().terminate();
                // empty out the lease manager.
                getLeaseManager().clear();
                // zap persistent storage
                locFile.delete();
                // shut down thread
                done = true;      
                thread.interrupt(); 
            }
        }
        public void setStorageLocation(String loc) 
            throws RemoteException {
            synchronized (AdminLeaseService.this) {
                try {
                    // try to pick up the current file and move it.
                    File newLocFile = new File(loc);
                    File oldLocFile = new File(getStorageLoc());
            
                    BufferedReader reader = 
                        new BufferedReader(new FileReader(oldLocFile));
                    BufferedWriter writer =
                        new BufferedWriter(new FileWriter(newLocFile));
            
                    char[] buffer = new char[1024];
                    int n;
                    while ((n = reader.read(buffer)) > 0) {
                        writer.write(buffer, 0, n);
                    }
                    reader.close();
                    writer.close();
                
                    setStorageLoc(loc);
                
                    oldLocFile.delete(); 
                } catch (IOException ex) {
                    throw new RemoteException(ex.toString());
                }
            }
        }
        public String getStorageLocation() {
            return getStorageLoc();
        }
        public Entry[] getLookupAttributes() {
            return getJoinManager().getAttributes();
        }
        public void addLookupAttributes(Entry[] attrs) 
            throws RemoteException {
            getJoinManager().addAttributes(attrs, true);
            try {
                AdminLeaseService.this.checkpoint();
            } catch (IOException ex) {
                throw new RemoteException(ex.toString());
            }
        }
        public void modifyLookupAttributes(Entry[] tmpls, 
                                           Entry[] attrs) 
            throws RemoteException {
            getJoinManager().modifyAttributes(tmpls, attrs, true);
            try {
                AdminLeaseService.this.checkpoint();
            } catch (IOException ex) {
                throw new RemoteException(ex.toString());
            }
        }
        public String[] getLookupGroups() {
            return getDiscoveryManager().getGroups();
        }
        public void addLookupGroups(String[] groups) 
            throws RemoteException {
            try {
                getDiscoveryManager().addGroups(groups);
                AdminLeaseService.this.checkpoint();
            } catch (IOException ex) {
                throw new RemoteException(ex.toString());
            }
        }
        public void removeLookupGroups(String[] groups) 
            throws RemoteException {
            // Note no IOException here.  Adding and setting 
            // groups may re-initiate discovery (hence they
            // may raise IOException), but removing cannot.
            getDiscoveryManager().removeGroups(groups);
            try {
                AdminLeaseService.this.checkpoint();
            } catch (IOException ex) {
                throw new RemoteException(ex.toString());
            }
        }
        public void setLookupGroups(String[] groups) 
            throws RemoteException {
            try {
                getDiscoveryManager().setGroups(groups);
            } catch (IOException ex) {
            }
            try {
                AdminLeaseService.this.checkpoint();
            } catch (IOException ex) {
                throw new RemoteException(ex.toString());
            }
        }
        public LookupLocator[] getLookupLocators() {
            return getDiscoveryManager().getLocators();
        }
        public void addLookupLocators(LookupLocator[] locs) 
            throws RemoteException {
            getDiscoveryManager().addLocators(locs);
            try {
                AdminLeaseService.this.checkpoint();
            } catch (IOException ex) {
                throw new RemoteException(ex.toString());
            }
        }
        public void removeLookupLocators(LookupLocator[] locs) 
            throws RemoteException {
            getDiscoveryManager().removeLocators(locs);
            try {
                AdminLeaseService.this.checkpoint();
            } catch (IOException ex) {
                throw new RemoteException(ex.toString());
            }
        }
        public void setLookupLocators(LookupLocator[] locs) 
            throws RemoteException {
            getDiscoveryManager().setLocators(locs);
            try {
                AdminLeaseService.this.checkpoint();
            } catch (IOException ex) {
                throw new RemoteException(ex.toString());
            }
        }
    }

    public AdminLeaseService(String storageLoc) 
        throws RemoteException,
        IOException, ClassNotFoundException {
        super(storageLoc);
    }
    
    // override getAdmin()
    public Object getAdmin() {
        try {
            if (remoteAdmin == null) {
                remoteAdmin = new RemoteLeaseAdminImpl();
            }
            if (admin == null) {
                admin = new LeaseAdminProxy(remoteAdmin);
            }
            
            return admin;
        } catch (RemoteException ex) {
            System.err.println("Error creating remote admin: " +
                               ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }
    
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: LeaseService <storage_loc>");
            System.exit(1);
        }
        
        try {
            AdminLeaseService src = 
                new AdminLeaseService(args[0]);
            while (!done) { 
                try {
                    thread = Thread.currentThread();
                    Thread.sleep(Long.MAX_VALUE);
                } catch (InterruptedException ex) {
                }
            }
        } catch (Exception ex) {
            System.err.println("Trouble starting: " + ex.getMessage());
            ex.printStackTrace();
        }
        System.exit(1);
    }
}
