// SlotResult encapsulates the return values from a leaseFreeSlot()
// operation.

package corejini.chapter13;

import net.jini.core.lease.Lease;
import java.io.Serializable;

public class SlotResult implements Serializable {
    protected int index;
    protected Lease lease;
    protected Object key;
    
    SlotResult(int index, Lease lease, Object key) {
        this.index = index;
        this.lease = lease;
	this.key = key;
    }
    
    public int getIndex() {
        return index;
    }
    public Lease getLease() {
        return lease; 
    }
    public Object getKey() {
	return key;
    }
    public String toString() {
        return "slot " + index + 
            " leased until " + 
            lease.getExpiration();
    }
}
