// Exercise the SlotProvider.

package corejini.chapter13;

import net.jini.core.lease.Lease;
import net.jini.lease.LeaseRenewalManager;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.Naming;

public class SlotClient implements Runnable {
    protected SlotProvider provider = null;
    protected LeaseRenewalManager mgr = null;
    
    public SlotClient() {
        mgr = new LeaseRenewalManager();
    }
    
    public void setSlotProvider(SlotProvider sp) {
        provider = sp;
    }
    
    public void run() {
	SlotResult res1, res2, res3;

        while (true) {
            try {
		res1 = provider.leaseFreeSlot("Hello", 10000);
		if (res1 != null) {
		    mgr.renewUntil(res1.getLease(), 
                                   Lease.ANY, null);
		} else {
		    System.out.println("No more slots!");
		}
		
		res2 = provider.leaseFreeSlot("there", 10000);
		if (res2 != null) {
		    mgr.renewUntil(res2.getLease(), 
                                   System.currentTimeMillis() +
				   (1000 * 20), null);
		} else {
		    System.out.println("No more slots!");
		}
            
		res3 = provider.leaseFreeSlot("World!", 10000);
		if (res3 != null) {
		    mgr.renewUntil(res3.getLease(), 
                                   Lease.ANY, null);
		} else {
		    System.out.println("No more slots!");
		}

		try {
		    System.err.println("Sleeping...");
		    Thread.sleep(1000 * 30);
		} catch (InterruptedException ex) {
		}
            
		try {
		    if (res3 != null) {
			System.out.println("Value of slot: " +
					   provider.getValue(res3.getKey()));
			System.out.println("Cancelling lease");
			mgr.cancel(res3.getLease());
			System.out.println("After cancellation.");
			System.out.println("Value of slot: " +
					   provider.getValue(res3.getKey()));
		    }
		} catch (Exception ex) {
		    System.err.println("Error: " + 
                                       ex.getMessage());
		}
            
		try {
		    System.err.println("Sleeping...");
		    Thread.sleep(1000 * 30);
		} catch (InterruptedException ex) {
		}

            } catch (RemoteException ex) {
                System.err.println("Bogus: " + 
                                   ex.getMessage());
                ex.printStackTrace();
            }
        }
    }
    
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: SlotClient <url>");
            System.exit(1);
        }

	if (System.getSecurityManager() == null) {
	    System.setSecurityManager(
		    new RMISecurityManager());
	}

        try {
            SlotProvider sp = (SlotProvider) 
                Naming.lookup(args[0]);
            SlotClient slotClient = new SlotClient();
            slotClient.setSlotProvider(sp);
            new Thread(slotClient).start();
        } catch (Exception ex) {
            System.err.println("Couldn't start SlotClient: " + 
                               ex.getMessage());
            System.exit(1);
        }
    }
}
