// Defines the remote (RMI) protocol between the proxy and
// the back-end.

package corejini.chapter12;

import net.jini.admin.Administrable;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.event.RemoteEventListener;
import java.rmi.Remote;
import java.rmi.RemoteException;

public interface RemoteLeaseRenewer extends Remote, Administrable {
    public void renewAny(Lease lease, RemoteEventListener listener)
                          throws RemoteException; 
    public void renewFor(Lease lease, long duration,
                         RemoteEventListener listener)
                         throws RemoteException;
    public void clear() throws RemoteException;
    public void remove(Lease lease) throws RemoteException,
        UnknownLeaseException;
    public void cancel(Lease lease) throws RemoteException,
        UnknownLeaseException;
    public long getRemainingDuration(Lease lease) throws RemoteException,
        UnknownLeaseException;
    public void setRemainingDuration(Lease lease, long expiration)
        throws RemoteException, UnknownLeaseException;
}
