// A subclass of RemoteEvent for lease events.

package corejini.chapter12;

import net.jini.core.lease.Lease;
import net.jini.core.event.RemoteEvent;

public class RemoteLeaseRenewalEvent extends RemoteEvent {
    protected Lease lease;
    protected long expiration;
    protected Throwable throwable;
    
    public RemoteLeaseRenewalEvent(long eventID,
                                   long seqNum,
                                   LeaseRenewalService renewer,
                                   Lease lease, long expiration,
                                   Throwable throwable) {
        super(renewer, eventID, seqNum, null);
        this.lease = lease;
        this.expiration = expiration;
        this.throwable = throwable;
    }
    public Lease getLease() {
        return lease;
    }
    public long getExpiration() {
        return expiration;
    }
    public Throwable getException() {
        return throwable;
    }
}
