//
// This intentionally has nearly the same api as LeaseRenewalManager.
// only here we raise remote exception.
//
// the reason we don't juse use the rmi stub for the leasing svc
// directly is that the proxy here must translate between absolute
// and relative time.
//
// The backend methods traffic *only* in relative time
//
package corejini.chapter12;

import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.event.RemoteEventListener;
import net.jini.admin.Administrable;
import java.io.Serializable;
import java.rmi.RemoteException;

public class LeaseServiceProxy implements LeaseRenewalService, 
    Serializable, Administrable {
    protected RemoteLeaseRenewer backend;
    
    public LeaseServiceProxy(RemoteLeaseRenewer backend) {
        this.backend = backend;
    }
    
    public void renewUntil(Lease lease, long expiration, 
                           RemoteEventListener listener) 
        throws RemoteException {
        // Translate between time formats.
        if (expiration == Lease.ANY) {
            backend.renewAny(lease, listener);
        } else {
            long duration = expiration - System.currentTimeMillis();
            backend.renewFor(lease, duration, listener);
        }
    }
    
    public void renewFor(Lease lease, long duration,
                         RemoteEventListener listener) 
        throws RemoteException {
        backend.renewFor(lease, duration, listener);
    }
    
    public void clear() throws RemoteException {
        backend.clear();
    }
    
    public void remove(Lease lease) throws RemoteException,
        UnknownLeaseException {
        backend.remove(lease);
    }
    
    public void cancel(Lease lease) throws RemoteException,
            UnknownLeaseException {
        backend.cancel(lease);
    }
    
    public long getExpiration(Lease lease) throws RemoteException,
                UnknownLeaseException {
        // Translate between time formats
        long dur = backend.getRemainingDuration(lease);
        return System.currentTimeMillis() + dur;
    } 
    
    public void setExpiration(Lease lease, long expiration) 
        throws RemoteException, UnknownLeaseException {
        // Translate between time formats
        backend.setRemainingDuration(lease, 
                                     expiration - System.currentTimeMillis());
    }
    
    public Object getAdmin() throws RemoteException {
        return backend.getAdmin();
    }
}
