// interface for the proxy -- clientside api.

package corejini.chapter12;

import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.event.RemoteEventListener;
import java.rmi.RemoteException;

public interface LeaseRenewalService  {
    public void renewUntil(Lease lease, long expiration,
                           RemoteEventListener listener)
                           throws RemoteException;
    public void renewFor(Lease lease, long duration,
                         RemoteEventListener listener)
                         throws RemoteException;
    public void clear() throws RemoteException;
    public void remove(Lease lease) throws RemoteException, 
        UnknownLeaseException;
    public void cancel(Lease lease) throws RemoteException,
        UnknownLeaseException;
    public long getExpiration(Lease lease) throws RemoteException,
        UnknownLeaseException;
    public void setExpiration(Lease lease, long expiration) 
        throws RemoteException, UnknownLeaseException;
}
