// A user interface for StorageLocationAdmin

package corejini.chapter11;

import com.sun.jini.admin.StorageLocationAdmin;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.rmi.RemoteException;

// Initialize with a ref to the admin object
public class StorageLocationAdminPanel extends JPanel {
    public StorageLocationAdminPanel(final StorageLocationAdmin admin) {
        super();

        setLayout(new BorderLayout());
        final JTextField loc = new JTextField();
        JButton button = new JButton("Set");
        JPanel panel = new JPanel();
        final JLabel currentLoc = new JLabel();
        panel.setLayout(new GridLayout(2, 2));
        panel.add(new JLabel("Current storage location: "));
        try {
            currentLoc.setText(admin.getStorageLocation());
            panel.add(currentLoc);
        } catch (RemoteException ex) {
            JOptionPane.showMessageDialog(null,
                                          "Couldn't get location:\n" +
                                          ex.getMessage(), "Alert",
                                          JOptionPane.ERROR_MESSAGE);
        }
        panel.add(new JLabel("New storage location: "));
        panel.add(loc);
        add(panel, BorderLayout.NORTH);
        
        button.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) {
                try {
                    admin.setStorageLocation(loc.getText());
                    currentLoc.setText(admin.getStorageLocation());
                } catch (Exception ex) {
                    JOptionPane.showMessageDialog(null,
                                                  "Couldn't set location:\n" +
                                                  ex.getMessage(),"Alert",
                                                  JOptionPane.ERROR_MESSAGE);
                }
            }
        });
        
        add(button, BorderLayout.SOUTH);
    }
}

