// A ListCellRenderer for services -- draws a service as its name
// if it has one, or a cleaned-up representation of the proxy's
// class

package corejini.chapter11;

import java.awt.Component;
import javax.swing.JList;
import javax.swing.JLabel;
import javax.swing.DefaultListCellRenderer;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.entry.Name;

class ServiceCellRenderer extends DefaultListCellRenderer {
    public Component getListCellRendererComponent(JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, value,
                                                         index, isSelected,
                                                         cellHasFocus);
        if (c instanceof JLabel) {
            JLabel l = (JLabel) c;
            if (value instanceof ServiceItem) {
                ServiceItem item = (ServiceItem) value;
                String s = null;
                // Use the Name attribute, if there is one.
                for (int i=0 ; i<item.attributeSets.length ; i++) {
                    if (item.attributeSets[i] instanceof Name) {
                        s = ((Name) item.attributeSets[i]).name;
                        break;
                    }
                }
                if (s == null) {
                    s = Browser.declassify(item.service.getClass().getName());
                }
                l.setText(s);
            }
        }
        return c;
    }
}

