// A ListCellRenderer for Lookup ServiceRegistrars --
// draws a ServiceRegistrar as its locator URL

package corejini.chapter11;

import java.awt.Component;
import javax.swing.JList;
import javax.swing.JLabel;
import javax.swing.DefaultListCellRenderer;
import java.rmi.RemoteException;
import net.jini.core.lookup.ServiceRegistrar;

public class LookupCellRenderer extends DefaultListCellRenderer {
    public Component getListCellRendererComponent(JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, value,
                                                         index, isSelected,
                                                         cellHasFocus);
        if (c instanceof JLabel) {
            JLabel l = (JLabel) c;
            if (value instanceof ServiceRegistrar) {
                ServiceRegistrar reg = (ServiceRegistrar) value;
                try {
                    l.setText(reg.getLocator().toString());
                } catch (RemoteException ex) {
                    System.err.println("Error getting locator: " +
                                       ex.getMessage());
                    l.setText(reg.toString());
                }
            }
        }
        return c;
    }
}

