// A class to receive RemoteEvents

package corejini.chapter11;

import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lookup.ServiceEvent;
import net.jini.core.lookup.ServiceRegistrar;

public class Listener extends UnicastRemoteObject 
    implements RemoteEventListener {
    Browser browser;

    Listener(Browser browser) throws RemoteException {
        super();
        this.browser = browser;
    }
    public void notify(RemoteEvent ev) {
        if (!(ev instanceof ServiceEvent))
            return;

        // we just update the whole set of services -- not efficient, but
        // shorter than mucking our way through the lists.
        browser.updateServices((ServiceRegistrar) ev.getSource());
    }
}


