// better as an inner class, but I've broken it out
// for legibility.  This class handles clicks on list
// items

package corejini.chapter11;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;

public class ListClickListener extends MouseAdapter {
    Browser browser;

    ListClickListener(Browser browser) {
        this.browser = browser;
    }
    public void mouseClicked(MouseEvent ev) {
        boolean doubleClick = ev.getClickCount() == 2;

        if (ev.getSource() instanceof JList) {
            JList list = (JList) ev.getSource();
            int index = list.locationToIndex(ev.getPoint());

            if (index == -1)
                return;

            if (list.getModel().equals(browser.getLookups())) {
                if (doubleClick) {
                    browser.lookupDoubleClicked(index);
                } else {
                    browser.lookupClicked(index);
                }
            } else if (list.getModel().equals(browser.getServices())) {
                if (doubleClick) {
                    browser.serviceDoubleClicked(index);
                } else {
                    browser.serviceClicked(index);
                }
            }
        }
    }
}

