// A list component for this application.

package corejini.chapter11;

import javax.swing.JPanel;
import javax.swing.JList;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.Action;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;

public class ListBox extends JPanel {
    protected Action addAction, removeAction, updateAction;
    protected JList list = new JList();
    protected JTextField field = new JTextField();
    protected JButton addButton = new JButton("Add");
    protected JButton removeButton = new JButton("Remove");
    protected Object lastSelected = null;
    
    public ListBox(String title, int rowCount) {
        this(null, null, null, title, rowCount);
    }
    
    // Create a ListBox initialized with our actions
    public ListBox(Action addAction, Action removeAction, 
                   Action updateAction, String title, int rowCount){
        super();
        this.addAction = addAction;
        this.removeAction = removeAction;
        
        setLayout(new BorderLayout());
        removeButton.setEnabled(false);
        list.setVisibleRowCount(rowCount);
        list.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent ev) {
                int idx = ev.getFirstIndex();
                
                if (idx == -1)
                    lastSelected = null;
                else
                    lastSelected = 
                        ((JList) ev.getSource()).getModel().getElementAt(idx);
                
                if (ev.getValueIsAdjusting())
                    return;
                
                if (((JList) ev.getSource()).getSelectedIndex() == -1)
                    removeButton.setEnabled(false);
                else
                    removeButton.setEnabled(true);
            }
        });
        
        setLayout(new BorderLayout());
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        JPanel gridPanel = new JPanel();
        gridPanel.setLayout(new GridLayout(2, 2));
        
        listPanel.add(new JLabel(title), BorderLayout.NORTH);
        listPanel.add(new JScrollPane(list,
                                  JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                  JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED),
                      BorderLayout.CENTER);
        
        gridPanel.add(addButton);
        gridPanel.add(field);
        
        gridPanel.add(removeButton);
        add(listPanel, BorderLayout.CENTER);
        add(gridPanel, BorderLayout.SOUTH);
        
        if (addAction != null)
            addButton.addActionListener(addAction);
        
        if (removeAction != null)
            removeButton.addActionListener(removeAction);
        
        // also update after add/remove
        if (updateAction != null) {
            addButton.addActionListener(updateAction);
            removeButton.addActionListener(updateAction);
            
            updateAction.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    // Change the action set
    public void setActions(Action add, Action remove, Action update) {
        if (addAction != null)
            addButton.removeActionListener(addAction);
        
        if (removeAction != null)
            removeButton.removeActionListener(removeAction);
        
        if (updateAction != null) {
            addButton.removeActionListener(updateAction);
            removeButton.removeActionListener(updateAction);
        }
        
        addAction = add;
        removeAction = remove;
        updateAction = update;
        
        if (addAction != null)
            addButton.addActionListener(addAction);
        
        if (removeAction != null)
            removeButton.addActionListener(removeAction);
        
        if (updateAction != null) {
            addButton.addActionListener(updateAction);
            removeButton.addActionListener(updateAction);
            
            updateAction.actionPerformed(new ActionEvent(this, 0, null));
        }
    }
    
    // Some "helper" list methods
    public Object getSelectedValue() {
        return lastSelected;
    }
    public JList getList() {
        return list;
    }
    public JTextField getField() {
        return field;
    }
}
