// A user interface for JoinAdmin

package corejini.chapter11;

import net.jini.admin.JoinAdmin;
import net.jini.core.discovery.LookupLocator;
import javax.swing.JPanel;
import javax.swing.BoxLayout;
import javax.swing.AbstractAction;
import java.awt.event.ActionEvent;
import java.awt.BorderLayout;
import java.rmi.RemoteException;

public class JoinAdminPanel extends JPanel {
    protected ListBox groupsList, locsList, attrsList;
    protected JoinAdmin admin;

    // An action for adding groups
    class AddAction extends AbstractAction {
        ListBox listbox;
        
        AddAction(ListBox lb) {
            listbox = lb;
        }
        public void actionPerformed(ActionEvent ev) {
            String newItem = listbox.getField().getText();
            
            try {
                if (listbox.equals(groupsList)) {
                    String[] items = new String[1];
                    items[0] = newItem;
                    if (items[0].equals("<public>"))
                        items[0] = "";
                    
                    admin.addLookupGroups(items);
                } else if (listbox.equals(locsList)) {
                    LookupLocator[] items = new LookupLocator[1];
                    items[0] = new LookupLocator(newItem);
                    admin.addLookupLocators(items);
                } else if (listbox.equals(attrsList)) {
                    // noop for now...
                }
            } catch (Exception ex) {
                System.err.println("Error adding item: " + ex.getMessage());
            }
        }
    }
    
    // An action for removing groups
    class RemoveAction extends AbstractAction {
        ListBox listbox;
        
        RemoveAction(ListBox lb) {
            listbox = lb;
        }
        public void actionPerformed(ActionEvent ev) {
            Object sel = listbox.getSelectedValue();
            
            if (sel == null)
                return;
            
            try {
                if (listbox.equals(groupsList)) {
                    String[] items = new String[1];
                    sel = (sel.equals("<public>") ? "" : sel);
                    items[0] = (String) sel;
                    admin.removeLookupGroups(items);
                } else if (listbox.equals(locsList)) {
                    LookupLocator[] items = new LookupLocator[1];
                    items[0] = (LookupLocator) sel;
                    admin.removeLookupLocators(items);
                } else if (listbox.equals(attrsList)) {
                    // noop for now...
                }
            } catch (Exception ex) {
                System.err.println("Error removing item: " + ex.getMessage());
            }
        }
    }
    
    // An action for updating groups
    class UpdateAction extends AbstractAction {
        ListBox listbox;
        
        UpdateAction(ListBox lb) {
            listbox = lb;
        }
        public void actionPerformed(ActionEvent ev) {
            Object[] items = null;
            try {
                if (listbox.equals(groupsList)) {
                    items = admin.getLookupGroups();
                    for (int i=0 ; i<items.length ; i++) {
                        if (items[i].equals(""))
                            items[i] = "<public>";
                    }
                } else if (listbox.equals(locsList)) {
                    items = admin.getLookupLocators();
                } else if (listbox.equals(attrsList)) {
                    items = admin.getLookupAttributes();
                }
                listbox.getList().setListData(items);
            } catch (Exception ex) {
                System.err.println("Error updating: " + ex.getMessage());
                listbox.getList().setListData(new String[0]);
            }
        }
    }
    
    public JoinAdminPanel(JoinAdmin ja) {
        super();
        
        admin = ja;
        
        groupsList = new ListBox("Lookup Groups", 4);
        groupsList.setActions(new AddAction(groupsList),
                              new RemoveAction(groupsList),
                              new UpdateAction(groupsList));
        
        attrsList = new ListBox("Lookup Attributes", 4);;
        attrsList.setActions(new AddAction(attrsList),
                             new RemoveAction(attrsList),
                             new UpdateAction(attrsList));
        locsList = new ListBox("Lookup Locators", 4);
        locsList.setActions(new AddAction(locsList),
                            new RemoveAction(locsList),
                            new UpdateAction(locsList));
        
        setLayout(new BorderLayout());
        
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        panel.add(groupsList);
        panel.add(attrsList);
        panel.add(locsList);
        
        add(panel, BorderLayout.CENTER);
    }
} 

