// A user interface for DiscoveryAdmin

package corejini.chapter11;

import net.jini.lookup.DiscoveryAdmin;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.AbstractAction;
import java.awt.event.ActionEvent;
import java.awt.BorderLayout;
import java.awt.GridLayout;

public class DiscoveryAdminPanel extends JPanel {
    protected ListBox listbox;
    protected JTextField portField = new JTextField();
    protected JLabel currentPort = new JLabel();
    protected DiscoveryAdmin admin;

    // An action for adding new groups
    class AddAction extends AbstractAction {
        public void actionPerformed(ActionEvent ev) {
            System.out.println("In add!");
            String[] newGroups = new String[1];
            
            newGroups[0] = listbox.getField().getText();
            if (newGroups[0].equals("<public>"))
                newGroups[0] = "";
            
            try {
                admin.addMemberGroups(newGroups);
            } catch (Exception ex) {
                System.err.println("Couldn't add group: " + 
                                   ex.getMessage());
            }
        }
    }
    
    // An action for removing groups
    class RemoveAction extends AbstractAction {
        public void actionPerformed(ActionEvent ev) {
            Object sel = listbox.getSelectedValue();
            
            if (sel == null) {
                return;
            }
            
            try {
                String[] items = new String[1];
                sel = (sel.equals("<public>") ? "" : sel);
                items[0] = (String) sel;
                admin.removeMemberGroups(items);
            } catch (Exception ex) {
                System.err.println("Couldn't remove group: " + 
                                   ex.getMessage());
            }
        }
    }
    
    // An action for changing groups
    class UpdateAction extends AbstractAction {
        public void actionPerformed(ActionEvent ev) {
            try {
                String[] members = admin.getMemberGroups();
                for (int i=0 ; i<members.length ; i++) {
                    if (members[i].equals(""))
                        members[i] = "<public>";
                }
                listbox.getList().setListData(members);
            } catch (Exception ex) {
                System.err.println("Couldn't update: " + 
                                   ex.getMessage());
                listbox.getList().setListData(new String[0]);
            }
        }
    }
    class SetPortAction extends AbstractAction {
        public void actionPerformed(ActionEvent ev) {
            try {
                admin.setUnicastPort(
                        Integer.parseInt(portField.getText()));
                currentPort.setText(
                        Integer.toString(admin.getUnicastPort()));
            } catch (Exception ex) {
                System.err.println("Couldn't change port: " + 
                                   ex.getMessage());
            }
        }
    }
    
    public DiscoveryAdminPanel(DiscoveryAdmin da) {
        super();
        
        admin = da;
        setLayout(new BorderLayout());

        // Create a ListBox and initialize it with our
        // actions
        listbox = new ListBox("Member Groups", 12);
        listbox.setActions(new AddAction(), 
                           new RemoveAction(), 
                           new UpdateAction());
        JPanel portPanel = new JPanel();
        portPanel.setLayout(new BorderLayout());
        JPanel gridPanel = new JPanel();
        gridPanel.setLayout(new GridLayout(2, 2));
        gridPanel.add(new JLabel("Current port: "));
        try {
            currentPort.setText(
                    Integer.toString(admin.getUnicastPort()));
        } catch (Exception ex) {
            System.err.println("Error setting port: " + 
                               ex.getMessage());
        }
        gridPanel.add(currentPort);
        gridPanel.add(new JLabel("New port: "));
        gridPanel.add(portField);
        portPanel.add(gridPanel, BorderLayout.CENTER);
        JButton button = new JButton("Set");
        button.addActionListener(new SetPortAction());
        portPanel.add(button, BorderLayout.SOUTH);
        
        add(listbox, BorderLayout.CENTER);
        add(portPanel, BorderLayout.SOUTH);
    }
} 

