// A class to manage discovery for us

package corejini.chapter11;

import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.core.lookup.ServiceRegistrar;

public class Discoverer implements DiscoveryListener {
    protected Browser browser;

    Discoverer(Browser browser) {
        this.browser = browser;
    }
    public void discovered(DiscoveryEvent ev) {
        ServiceRegistrar regs[] = ev.getRegistrars();
        System.out.println("discovered! " + regs.length);
        for (int i=0  ; i<regs.length ; i++) {
            if (!browser.getLookups().contains(regs[i])) {
                System.out.println("adding " + regs[i]);
                browser.getLookups().addElement(regs[i]);
            } else {
                System.out.println("already contains...");
            }
        }
    }
    public void discarded(DiscoveryEvent ev) {
        ServiceRegistrar regs[] = ev.getRegistrars();
        for (int i=0  ; i<regs.length ; i++) {
            browser.getLookups().removeElement(regs[i]);
        }
    }
}

