// A user interface for DestroyAdmin

package corejini.chapter11;

import com.sun.jini.admin.DestroyAdmin;
import javax.swing.JPanel;
import javax.swing.JOptionPane;
import javax.swing.JLabel;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.BorderLayout;
import java.rmi.RemoteException;

// initialize with a ref to the admin object
public class DestroyAdminPanel extends JPanel {
    public DestroyAdminPanel(final DestroyAdmin admin) {
        super();
        
        setLayout(new BorderLayout());
        
        JLabel label;
        JButton button;
        
        add(new JLabel("CAUTION:"), BorderLayout.NORTH);
        add(new JLabel("Clicking will terminate the service!"),
            BorderLayout.CENTER);

        button = new JButton("Terminate");
        
        button.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) {
                try {
                    admin.destroy();
                } catch (RemoteException ex) {
                    JOptionPane.showMessageDialog(null,
                            "Couldn't destroy service:\n"+
                            ex.getMessage(), "Alert",
                            JOptionPane.ERROR_MESSAGE);
                }
            }
        });
        
        add(button, BorderLayout.SOUTH);
    }
}
