// A ListCellRenderer for attributes -- draws attributes as components
// if they are, or uses the name of the class along with its toString()
// representation

package corejini.chapter11;

import java.awt.Component;
import javax.swing.JList;
import javax.swing.DefaultListCellRenderer;
import net.jini.core.entry.Entry;

public class AttrCellRenderer extends DefaultListCellRenderer {
    public Component getListCellRendererComponent(JList list, Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, value,
                                                         index,
                                                         isSelected,
                                                         cellHasFocus);
        return Browser.getComponentForEntry((Entry) value, c);
    }
}

