// wrap an array list so that we notify listeners
// when a change occurs

package corejini.chapter11;

import java.util.ArrayList;
import javax.swing.AbstractListModel;

public class ArrayListModel extends AbstractListModel {
    ArrayList a = new ArrayList();

    public Object getElementAt(int index) {
        return a.get(index);
    }
    public int getSize() {
        return a.size();
    }
    boolean contains(Object o) {
        return a.contains(o);
    }
    synchronized void addElement(Object o) {
        a.add(o);
        fireIntervalAdded(this, a.size(), a.size());
    }
    synchronized void removeElement(Object o) {
        int index = a.indexOf(o);
        if (index != -1) {
            a.remove(index);
            fireIntervalRemoved(this, index, index);
        }
    }
    synchronized void setData(ArrayList newArrayList) {
        int len = a.size();
        a = newArrayList;
        fireIntervalRemoved(this, 0, len);
        fireIntervalAdded(this, 0,  a.size());
    }
}

