// This is the overall administration GUI.   You pass it
// an admin object, it introspects it to figure out which
// interface it implements, and puts up the tabbed panes.

package corejini.chapter11;

import net.jini.admin.JoinAdmin;
import net.jini.lookup.DiscoveryAdmin;
import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.admin.StorageLocationAdmin;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import java.awt.BorderLayout;

public class AdminPanel extends JPanel {
    
    public AdminPanel(Object admin) {
        super();

        setLayout(new BorderLayout());
        JTabbedPane pane = new JTabbedPane();
        
        if (admin instanceof DiscoveryAdmin) {
            DiscoveryAdminPanel panel = 
                new DiscoveryAdminPanel((DiscoveryAdmin) admin);
            pane.addTab("Discovery", panel);
        }
        if (admin instanceof StorageLocationAdmin) {
            StorageLocationAdminPanel panel = 
                new StorageLocationAdminPanel((StorageLocationAdmin) admin);
            pane.addTab("Storage", panel);
        }
        if (admin instanceof DestroyAdmin) {
            DestroyAdminPanel panel = 
                new DestroyAdminPanel((DestroyAdmin) admin);
            pane.addTab("Destroy", panel);
        }
        if (admin instanceof JoinAdmin) {
            JoinAdminPanel panel = 
                new JoinAdminPanel((JoinAdmin) admin);
            pane.addTab("Join", panel);
        }
        
        add(pane, BorderLayout.CENTER);
    }
}
