// A filter that matches services whose ServiceInfo.version
// matches a search parameter

package corejini.chapter10;

import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.ServiceItemFilter;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.core.entry.Entry;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ServiceInfoVersionFilter implements ServiceItemFilter {
    public static final int EQUAL = 1;
    public static final int EQUAL_OR_GREATER = 2;
        
    protected String test;
    protected String[] testTokens;
    protected int cond;
        
    public ServiceInfoVersionFilter(String test, int cond) {
        this.test = test;
        this.cond = cond;
        testTokens = makeVersionTokens(test);
    }
        
    // version numbering is an inexact science, but this covers
    // many cases.
    public boolean check(ServiceItem item) {
        Entry[] attrs = item.attributeSets;
        for (int i=0 ; i<attrs.length ; i++) {
            // If it's a ServiceInfo or subclass
            if (ServiceInfo.class.isAssignableFrom(attrs[i].getClass())) {
                String target = ((ServiceInfo) attrs[i]).version;

                if (target.equals(test)) {
                    return true;
                }
                    
                switch (cond) {
                case EQUAL:
                    return false;
                case EQUAL_OR_GREATER:
                    String[] targetTokens = makeVersionTokens(target);
                        
                    // cycle through each.  If any element in target is
                    // less than the corresponding element in
                    // test, report false.
                    int min = Math.min(testTokens.length,
                                       targetTokens.length);
                    for (int j=0 ; j<min ; j++) {
                        try {
                            int testVal = 
                                Integer.parseInt(testTokens[j]);
                            int targetVal = 
                                Integer.parseInt(targetTokens[j]);
                            
                            if (targetVal < testVal) {
                                return false;
                            }
                        } catch (NumberFormatException ex) {
                            System.err.println("Unexpected format: " +
                                               testTokens[i] + ", " +
                                               targetTokens[i]);
                            ex.printStackTrace();
                        }
                    }
                        
                    return testTokens.length <= targetTokens.length;
                }
            }
        }
            
        return false;
    }
        
    // convert a string of the form 1.2.2.1 into a string array
    static String[] makeVersionTokens(String v) {
        String str = v;
        // jettison everything after a space
        if (str.indexOf(' ') != -1) {
            str = str.substring(0, str.indexOf(' '));
        }
        StringTokenizer t = new StringTokenizer(str, ".");
        ArrayList arr = new ArrayList();
        while (t.hasMoreTokens()) {
            arr.add(t.nextToken());
        }
        return (String[]) arr.toArray(new String[0]);
    }    
} 
