// A filter that matches services whose ServiceInfo.vendor
// contains a given substring.

package corejini.chapter10;

import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.ServiceItemFilter;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.core.entry.Entry;

public class ServiceInfoVendorFilter implements ServiceItemFilter {
    protected String substring;
    
    public ServiceInfoVendorFilter(String substring) {
        this.substring = substring;
    }
        
    public boolean check(ServiceItem item) {
        Entry[] attrs = item.attributeSets;
        for (int i=0 ; i<attrs.length ; i++) {
            // If it's a ServiceInfo or subclass
            if (ServiceInfo.class.isAssignableFrom(attrs[i].getClass())) {
                return ((ServiceInfo) 
                        attrs[i]).vendor.indexOf(substring) != -1;
            }
        }
            
        return false;
    }    
} 
