// A ServiceDiscoveryListener that shows what's changed

package corejini.chapter10;

import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.LookupCache;
import net.jini.core.entry.Entry;

public class DiffListener implements ServiceDiscoveryListener {
    public DiffListener() {
    }
    
    // The preEventServiceItem will be null, while the
    // postEventServiceItem will hold the newly-added
    // service item
    public void serviceAdded(ServiceDiscoveryEvent ev) {
        System.out.println("+++ SERVICE ADDED");
        ServiceItem item = ev.getPostEventServiceItem();
        printServiceItem(item);
    }
    
    // The preEventServiceItem holds the newly-removed 
    // service, while the postEventServiceItem is null
    public void serviceRemoved(ServiceDiscoveryEvent ev) {
        System.out.println("+++ SERVICE REMOVED");
        ServiceItem item = ev.getPreEventServiceItem();
        System.out.println("Service's ID was " + item.serviceID);
    }
    
    public void serviceChanged(ServiceDiscoveryEvent ev) {
        System.out.println("+++ SERVICE CHANGED");

        // Get both the pre and post service items.
        ServiceItem pre = ev.getPreEventServiceItem();
        ServiceItem post = ev.getPostEventServiceItem();
       
	// This shouldn't happen!
        if (pre == null && post == null) {
            System.out.println("Null service items!?");
            return;
        }
      
	// This block of code looks at the proxies to determine
	// if they've changed.  It also looks for some common
	// error cases...notably, if the proxy is null, chances
	// are you've got codebase problems.
        if (pre.service == null && post.service == null) {
            System.out.println("The service's proxy is still null");
            System.out.println("Codebase problem?");
        } else if (pre.service == null && post.service != null) {
            System.out.println("The service's proxy is no " +
                               "longer null");
            System.out.println("Proxy now: " + post.service + " (" + 
                        post.service.getClass().getName() + ")");
        } else if (pre.service != null && post.service == null) {
            System.out.println("The service's proxy has become null");
            System.out.println("Check codebase");
        } else if (!pre.service.equals(post.service)) {
            System.out.println("The service's proxy has changed");
            System.out.println("Proxy was: " + pre.service + " (" + 
                        pre.service.getClass().getName() + ")");
            System.out.println("Proxy now: " + post.service + " (" + 
                        post.service.getClass().getName() + ")");
        }
       
	// The ID of a service should *never* change. If it
	// does change, chances are you've changed the ID
	// in a ServiceItem in the cache!  Remember that you
	// should never write to ServiceItems in the cache.
        if (!pre.serviceID.equals(post.serviceID)) {
            System.err.println("Uh oh, the ID has changed");
            System.err.println("Don't muck with the service items!");
            System.out.println("ID was: " + pre.serviceID);
            System.out.println("ID now: " + pre.serviceID);
        } else {
            System.out.println("ID: " + pre.serviceID);
        }

	// Other changes can happen because of attribute
	// modifications.  This code doesn't detect those...
    }
    
    // A helper method to print out a service item
    public static void printServiceItem(ServiceItem item) {
        if (item == null) {
            System.out.println("Bogus: null service item");
            return;
        }
        
        if (item.service == null) {
            System.out.println("Bogus: service proxy is null");
            System.out.println("This service's codebase is " +
                               "probably misconfigured");
        } else {
            System.out.println("Proxy: " + item.service);
            System.out.println("Class: " + 
                               item.service.getClass().getName());
        }
        
        System.out.println("ID:    " + item.serviceID);
        
        Entry[] attrs = item.attributeSets;
        
        if (attrs == null || attrs.length == 0) {
            System.out.println("Service has no attributes");
        } else {
            for (int i=0 ; i<attrs.length ; i++) {
                System.out.print("[" + i + "] ");
                if (attrs[i] == null) {
                    System.out.println("null entry (possible " +
                                       "codebase problem)");
                } else {
                    System.out.println(attrs[i]);
                }
            }
        }
    }
} 
